![[Pasted image 20250512091817.png]]

 #### **Overview**

- Cisco Umbrella is a **cloud-based Secure Internet Gateway (SIG)** platform.
- Provides multiple layers of defense against internet-based threats.
- Combines various security functions into a single, cloud-native solution.

![[Pasted image 20250512095030.png]]

![[Pasted image 20250512095106.png]]


![[Pasted image 20250512095135.png]]

![[Pasted image 20250512095213.png]]

![[Pasted image 20250512095329.png]]

![[Pasted image 20250512095359.png]]



---

### **Key Features and Functionalities**

#### **Core Security Features**

1. **DNS-Layer Security**:
    
    - Blocks access to malicious domains (e.g., malware, phishing).
    - Acts as the first layer of defense by intercepting DNS requests.
2. **Secure Web Gateway (SWG)**:
    
    - Provides deeper inspection of web traffic.
    - Offers full web proxy functionality for granular visibility and control.
3. **Cloud-Delivered Firewall**:
    
    - Layer 3 and 4: Centralized IP, port, and protocol rule management.
    - Layer 7: Application visibility and control for non-web applications.
    - Includes Cisco Intrusion Prevention System (IPS) for enhanced security.
4. **Cloud Access Security Broker (CASB)**:
    
    - Monitors and controls cloud application usage based on risk levels.
    - Detects and removes malware from cloud file storage apps.
    - Prevents accidental or malicious exposure of sensitive data with **Data Loss Prevention (DLP)**.
5. **Remote Browser Isolation (RBI)**:
    
    - Isolates web page execution in the cloud to protect against browser-based threats.
6. **Cisco Talos Threat Intelligence**:
    
    - Leverages machine learning and threat data for advanced threat detection and prevention.

#### **Additional Capabilities**

- Visibility into internet and web traffic across all ports and protocols.
- Flexible deployment options for DNS-layer security, web gateway, or firewall services.
- Policy-based controls to enforce compliance and corporate guidelines.

---

### **Cisco Umbrella Packages**

1. **DNS Security Essentials**:
    
    - Core DNS-layer security with on/off network protection.
    - Includes APIs, log exporting, and identity-based policies.
2. **DNS Security Advantage**:
    
    - Adds deeper web inspection with selective web proxy.
    - Provides access to interactive threat intelligence for investigations.
3. **Secure Internet Gateway Essentials**:
    
    - Combines DNS Security Advantage with SWG, firewall, CASB, and malware analytics.
4. **Secure Internet Gateway Advantage**:
    
    - Highest level of protection with Layer 7 firewall, intrusion prevention, DLP, and unlimited malware analytics.

#### **Add-Ons**:

- **Layer 7 Cloud Firewall**: Adds application visibility and Cisco IPS.
- **Remote Browser Isolation**: Protects against risky websites.
- **Data Loss Prevention**: Analyzes and protects sensitive data in the cloud.
- **Reserved IP**: Dedicated IP for secure traffic egress.

---

### **Cisco Umbrella Architecture**

#### **Cloud-Native Design**:

- Leverages geographically distributed data centers near Internet Exchange Points (IXPs).
- Uses **Anycast routing** for high availability, low latency, and automatic rerouting in case of outages.
- Employs **microservices** for scalability and resilience.
- Maintains peering partnerships with ISPs, CDNs, and SaaS providers to optimize performance.

#### **Self-Healing Infrastructure**:

- Features global load balancing and auto-scaling for seamless issue resolution.
- Provides continuous security updates without downtime.

---

### **Cisco Umbrella Deployment Options**

#### **Core Deployment Options**:

- **DNS Security**:
    
    - Configure DHCP scopes or internal DNS servers to forward requests to Umbrella DNS servers.
    - Deploy a **Virtual Appliance** for internal IP visibility. Otherwies, **Dynamic PAT** will be used where multiple devices on a private network will share a single public IP address by using unique source ports.  
**Example**:
    - Device A (192.168.1.10:5000) → Translated to 203.0.113.1:40001
    - Device B (192.168.1.11:5000) → Translated to 203.0.113.1:40002

- **Secure Web Gateway and Firewall**:
    
    - Deploy **IPsec tunnels** from edge devices (headquarters or branch offices) to Cisco Umbrella.
    - Enables direct internet access (DIA) with cloud-delivered security.

- **Mobile Clients**:
    
    - Use the **Cisco Umbrella Roaming Security** module for Secure Client.
    - Redirects DNS and web traffic to enforce policies and block threats.
**Example**: 
![[Pasted image 20250512103210.png]]
---

### **Use Cases**

- Ideal for organizations needing DNS-layer security, web traffic inspection, or cloud-delivered firewalls.
- Supports:
    - **Headquarters**: Protect users, devices, and applications with IPsec tunnels.
    - **Branch Offices**: Enable DIA with DNS-layer security and cloud-delivered firewalls.
    - **Remote Workers**: Secure mobile clients connected to public/home networks.

---

### **Cisco Umbrella Dashboard**

- Managed via a public cloud-based dashboard accessible from any internet connection.
- Allows configuration of identities, policies, and reporting in a centralized interface.

---

### **Key Benefits**

- Reduces complexity, costs, and resource requirements for security deployment.
- Provides flexible functionality tailored to specific users or locations.
- Ensures fast, reliable, and secure internet access with minimal latency.